<?php defined('PF_VERSION') OR exit('Access denied'); ?>
<?php
if (!empty($_POST['cid'])) {
    foreach ($_POST['cid'] as $cid) {
        $portfolio->portfolio_action($cid, $_POST['action']);
    }
}
$list_all = $portfolio->list_portfolio($clause, $array_clause,'portfolio_id,portfolio_name,portfolio_description,portfolio_status');
if (!isset($_GET['page']))
    $page = 0;
else
    $page = $_GET['page'] - 1;
$org_url = "?admin-page=portfolio&sub_page=portfolio";
$ppage = NUM_PER_PAGE;
$limit = $page * $ppage;
$total = count($list_all);
$list = array();
for ($i = $limit; $i < $limit + $ppage; $i++) {
    if (!empty($list_all[$i]))
        $list[] = $list_all[$i];
}
$pages = new Pf_Paginator($total, NUM_PER_PAGE, 'page');
add_toolbar_button(form_button("<i class='glyphicon glyphicon-plus'></i> " . __('New Portfolio', 'portfolio'), array('onclick' => "window.location = '" . $_SERVER["REQUEST_URI"] . "&action=create'", 'class' => 'btn btn-primary')));
?>
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-list"></i> <?php echo __('Portfolio', 'portfolio'); ?></h3>
    </div>
    <div class="panel-body">
        <div class="row">
            <div class="col-md-8">
                <div class="btn-group pull-left btnGroupBulkAction" id="action-box" style="display: none;">
                    <button type="button" class="btn btn-default btn-md btn-flat dropdown-toggle" data-toggle="dropdown">
                        <?php echo __('Select Action', 'portfolio'); ?> <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu" role="menu" id="bulkAction">
                        <li><a href="#" onclick="confirmaction('delete')"><?php echo __('Delete', 'portfolio'); ?></a></li>
                        <li><a href="#" onclick="confirmaction('publish')"><?php echo __('Publish', 'portfolio'); ?></a></li>
                        <li><a href="#" onclick="confirmaction('unpublish')"><?php echo __('Unpublish', 'portfolio'); ?></a></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 search-form">
                <form name="search" method="get" action="" class="form-inline">
                    <div class="input-group">
                        <input type="hidden" name="admin-page" value="portfolio" />
                        <input type="hidden" name="sub_page" value="portfolio" />
                        <input type="text" class="form-control" name="port-name" placeholder='<?php echo __('Please enter portfolio name','portfolio'); ?>'>
                        <span class="input-group-btn">
                            <button class="btn btn-default" type="submit" id="btnSearch">
                                <i class="fa fa-search"></i> <?php echo __('Search', 'portfolio') ?>
                            </button>
                            <a href="<?php echo admin_url(array('admin-page' => 'portfolio', 'sub_page' => 'portfolio'), false); ?>" class="btn btn-default btn-flat"> 
                                <i class="fa fa-times-circle"></i>
                            </a>
                        </span>
                    </div>
                </form>
            </div>
        </div>
        <div class="row padding-10-0">
            <div class="col-md-8">

                    <ul class="list-unstyled filer">
                        <li class="filterByStatus">
                            <div class="btn-group">
                                <?php $list_cat = $portfolio->list_cat('',array(),'category_id,category_name');?>
                                <?php if(isset($_GET['cat_id'])&&isset($list_cat[$_GET['cat_id']])): ?>
                                    <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
                                        <?php echo $list_cat[$_GET['cat_id']]['category_name']; ?> <span class="caret"></span>
                                    </button>
                                <?php else: ?>
                                <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
                                    <?php echo __('All Portfolio', 'portfolio'); ?> <span class="caret"></span>
                                </button>
                                <?php endif;?>
                                <ul class="dropdown-menu" role="menu">
                                    <li><a href="<?php echo admin_url('admin-page=portfolio&sub_page=portfolio', false); ?>"><?php echo __('All Portfolio', 'portfolio'); ?></a></li>
                                    <?php  foreach ($list_cat as $item) {?>
                                           <li><a href="<?php echo admin_url('admin-page=portfolio&sub_page=portfolio', false); ?>&cat_id=<?php echo $item['category_id']; ?>"><?php echo $item['category_name']; ?></a></li>
                                    <?php }?>
                                </ul>
                            </div>
                        </li>
                    </ul>


            </div>
            <div class="col-sm-4">
              
                <?php echo $pages->short_page_link();?>					<!-- Pagination -->
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <form method=post action='' id='checkform'>
                    <input type="hidden" id='action' name="action" />
                    <div class="table-responsive">
                        <table class="bootstrap-table">
                            <thead>
                                <tr>
                                    <th data-fixed="left"><input type='checkbox' id='checkall' name='checkall' /></th>
                                    <th class="width150"><?php echo __('Portfolio name', 'portfolio'); ?></th>
                                    <th class="width200"><?php echo __('Shortcode', 'portfolio'); ?></th>
                                    <th class="width400"><?php echo __('Description', 'portfolio'); ?></th>
                                    <th class="width80"><?php echo __('Status', 'portfolio'); ?></th>
                                    <th data-fixed="right" class="width100 center"><?php echo __('Actions', 'portfolio'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
<?php if (!empty($list)) {
    foreach ($list as $item) { ?>
                                        <tr>
                                            <td> <input type='checkbox' name='cid[]' value=' <?php echo $item['portfolio_id']; ?> ' class='checkbox' /></td>
                                            <td><?php echo $item['portfolio_name'] ?></td>
                                            <td>{pf:portfolio portid=<?php echo $item['portfolio_id']; ?>}</td>
                                            <td><?php echo substr($item['portfolio_description'], 0, 80); ?></td>
                                            <td><?php 
                                            switch ($item['portfolio_status']) {
                                                        case '1':
                                                            echo "<a href='" . admin_url("admin-page=portfolio&sub_page=portfolio&do=unpublish&id=" . $item['portfolio_id']) . "' class='label label-success'>" . __("Published", 'portfolio') . "</a>";
                                                            break;
                                                        default:
                                                            echo "<a href='" . admin_url("admin-page=portfolio&sub_page=portfolio&do=publish&id=" . $item['portfolio_id']) . "' class='label label-danger'>" . __("Unpublished", 'portfolio') . "</a>";
                                                            break;
                                                        }
                                            ?></td>
                                            <td> 
                                                <a class="btn btn-info btn-xs" href="<?php echo admin_url('action=edit&id=' . $item['portfolio_id']); ?>">
                                                    <i class="fa fa-pencil-square-o"></i> <?php echo __('Edit', 'portfolio'); ?>
                                                </a> 
                                                <a class="btn btn-danger btn-xs" onclick="delete_menu('<?php echo admin_url('action=delete&id=' . $item['portfolio_id']); ?>');
                                                            return;">
                                                    <i class="fa fa-times-circle"></i> <?php echo __('Delete', 'portfolio'); ?>
                                                </a>
                                            </td>
                                        </tr>
    <?php }
} ?>
                            </tbody>
                        </table>
                    </div>
                </form>         
            </div>
        </div>
    </div>
    <div class="panel-footer">
        <div class="row">
            <div class="col-sm-6">
                <?php echo $pages->page_lable(); ?>
            </div>
            <div class="col-sm-6">
                <!-- Pagination -->
                <?php echo $pages->page_links($org_url . '&'); ?>
                <!-- Pagination -->
            </div>
        </div>
    </div>
</div>
<div id="addnew" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="false" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title" id="myModalLabel">Add Menu</h4>
            </div>
            <form name="add" method="post" action="" class="form-horizontal">
                <div class="modal-body">
                    <div class="form-group">
                        <label class="col-sm-4 control-label">Menu Title</label>
                        <div class="col-sm-8">
                            <input type="text" class="form-control" name="title" id="title" value="">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label">Publish</label>
                        <div class="col-sm-8">
                            <select class="form-control" name="publish">
                                <option value="1">Yes</option>
                                <option value="0">No</option>                   
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal" name="add">Close</button>
                    <button type="submit" name="add" class="btn btn-primary">Add new</button>
                </div>
            </form>    
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<script>
    function delete_menu(url) {
        $.sModal({
            image: '<?php echo RELATIVE_PATH; ?>/admin/plugins/theme/layouts/images/confirm.png',
            content: '<?php echo __('Are you sure to delete this item?', 'portfolio'); ?>',
            animate: 'fadeDown',
            buttons: [
                {
                    text: '<i class="fa fa-times-circle"></i> <?php echo __('Delete', 'portfolio'); ?> ',
                    addClass: 'btn-danger',
                    click: function(id, data) {
                        window.location = url;
                        $.sModal('close', id);
                    }
                },
                {
                    text: ' <?php echo __('Cancel', 'portfolio'); ?> ',
                    click: function(id, data) {
                        $.sModal('close', id);
                    }
                },
            ]
        });
    }
    function confirmaction(act) {
        $.sModal({
                image: '<?php echo RELATIVE_PATH; ?>/admin/plugins/theme/layouts/images/confirm.png',
                content: '<?php echo __('Are you sure with this action?', 'portfolio'); ?>',
                animate: 'fadeDown',
                buttons: [
                    {
                        text: '<i class="fa fa-times-circle"></i> <?php echo __('Confirm', 'portfolio'); ?> ',
                        addClass: 'btn-danger',
                        click: function(id, data) {
                           $('#action').val(act);
                           $('#checkform').submit();
                            $.sModal('close', id);
                        }
                    },
                    {
                        text: ' <?php echo __('Cancel', 'portfolio'); ?> ',
                        click: function(id, data) {
                            $.sModal('close', id);
                        }
                    },
                ]
            });
    }
</script>